// processar_nos.js — Windows Script Host JScript (not modern JS)

var fso = new ActiveXObject("Scripting.FileSystemObject");

// ----------------------------
// Utility trim (old JS)
// ----------------------------
function trim(s) {
    if (s == null) return "";
    s = String(s);
    var a = 0, b = s.length - 1;
    while (a <= b && s.charCodeAt(a) <= 32) a++;
    while (b >= a && s.charCodeAt(b) <= 32) b--;
    return s.substring(a, b + 1);
}

// ----------------------------
// Read Results.csv
// ----------------------------
if (!fso.FileExists("Results.csv")) {
    WScript.Echo("ERRO: Results.csv não encontrado.");
    WScript.Quit(1);
}

var file = fso.OpenTextFile("Results.csv", 1);
var header = true;
var groups = {};   // { A: {ext:[], int:[]} }

while (!file.AtEndOfStream) {
    var line = trim(file.ReadLine());
    if (header) { header = false; continue; }
    if (line === "") continue;

    // split by comma ONLY
    var parts = line.split(",");
    if (parts.length < 3) continue;

    var label = trim(parts[1]);
    var area  = parseFloat(parts[2]);

    if (isNaN(area)) continue; // skip non-numeric

    // label example: 204G:AE
    var pos = label.indexOf(":");
    if (pos < 0) continue;

    var suffix = label.substring(pos + 1); // AE, AI, BE, BI, etc.
    if (suffix.length < 2) continue;

    var group = suffix.charAt(0).toUpperCase(); // A, B, C...
    var kind  = suffix.charAt(suffix.length - 1).toUpperCase(); // E or I

    if (!groups[group])
        groups[group] = { ext: [], int: [] };

    if (kind === "E")
        groups[group].ext.push(area);
    else if (kind === "I")
        groups[group].int.push(area);
}

file.Close();

// ----------------------------
// Compute averages correctly
// ----------------------------
function avg(arr) {
    if (!arr || arr.length === 0) return "";
    var s = 0;
    for (var i = 0; i < arr.length; i++) s += arr[i];
    return (s / arr.length).toFixed(3);
}

// ----------------------------
// Write output CSV
// ----------------------------
var out = fso.CreateTextFile("medidas dos nos.csv", true);
out.WriteLine("Grupo,Externa,Interna,Media");

for (var g in groups) {
    var E = avg(groups[g].ext);
    var I = avg(groups[g].int);

    var M = "";
    if (E !== "" && I !== "")
        M = ((parseFloat(E) + parseFloat(I)) / 2).toFixed(3);
    else if (E !== "")
        M = E;
    else if (I !== "")
        M = I;

    out.WriteLine(g + "," +
        (E === "" ? "" : E) + "," +
        (I === "" ? "" : I) + "," +
        M);
}

out.Close();
